// Generated by CoffeeScript 1.7.1
(function() {
  var AllowTransparencyAttribute, AutosizeAttribute, AutosizeDimensionAttribute, BooleanAttribute, HttpReferrerAttribute, PartitionAttribute, PreloadAttribute, SrcAttribute, WebViewAttribute, WebViewImpl, a, guestViewInternal, remote, resolveUrl, webViewConstants,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  WebViewImpl = require('./web-view');

  guestViewInternal = require('./guest-view-internal');

  webViewConstants = require('./web-view-constants');

  remote = require('remote');

  a = document.createElement('a');

  resolveUrl = function(url) {
    a.href = url;
    return a.href;
  };

  WebViewAttribute = (function() {
    function WebViewAttribute(name, webViewImpl) {
      this.name = name;
      this.webViewImpl = webViewImpl;
      this.ignoreMutation = false;
      this.defineProperty();
    }

    WebViewAttribute.prototype.getValue = function() {
      return this.webViewImpl.webviewNode.getAttribute(this.name) || '';
    };

    WebViewAttribute.prototype.setValue = function(value) {
      return this.webViewImpl.webviewNode.setAttribute(this.name, value || '');
    };

    WebViewAttribute.prototype.setValueIgnoreMutation = function(value) {
      this.ignoreMutation = true;
      this.webViewImpl.webviewNode.setAttribute(this.name, value || '');
      return this.ignoreMutation = false;
    };

    WebViewAttribute.prototype.defineProperty = function() {
      return Object.defineProperty(this.webViewImpl.webviewNode, this.name, {
        get: (function(_this) {
          return function() {
            return _this.getValue();
          };
        })(this),
        set: (function(_this) {
          return function(value) {
            return _this.setValue(value);
          };
        })(this),
        enumerable: true
      });
    };

    WebViewAttribute.prototype.handleMutation = function() {};

    return WebViewAttribute;

  })();

  BooleanAttribute = (function(_super) {
    __extends(BooleanAttribute, _super);

    function BooleanAttribute(name, webViewImpl) {
      BooleanAttribute.__super__.constructor.call(this, name, webViewImpl);
    }

    BooleanAttribute.prototype.getValue = function() {
      return this.webViewImpl.webviewNode.hasAttribute(this.name);
    };

    BooleanAttribute.prototype.setValue = function(value) {
      if (!value) {
        return this.webViewImpl.webviewNode.removeAttribute(this.name);
      } else {
        return this.webViewImpl.webviewNode.setAttribute(this.name, '');
      }
    };

    return BooleanAttribute;

  })(WebViewAttribute);

  AllowTransparencyAttribute = (function(_super) {
    __extends(AllowTransparencyAttribute, _super);

    function AllowTransparencyAttribute(webViewImpl) {
      AllowTransparencyAttribute.__super__.constructor.call(this, webViewConstants.ATTRIBUTE_ALLOWTRANSPARENCY, webViewImpl);
    }

    AllowTransparencyAttribute.prototype.handleMutation = function(oldValue, newValue) {
      if (!this.webViewImpl.guestInstanceId) {
        return;
      }
      return guestViewInternal.setAllowTransparency(this.webViewImpl.guestInstanceId, this.getValue());
    };

    return AllowTransparencyAttribute;

  })(BooleanAttribute);

  AutosizeDimensionAttribute = (function(_super) {
    __extends(AutosizeDimensionAttribute, _super);

    function AutosizeDimensionAttribute(name, webViewImpl) {
      AutosizeDimensionAttribute.__super__.constructor.call(this, name, webViewImpl);
    }

    AutosizeDimensionAttribute.prototype.getValue = function() {
      return parseInt(this.webViewImpl.webviewNode.getAttribute(this.name)) || 0;
    };

    AutosizeDimensionAttribute.prototype.handleMutation = function(oldValue, newValue) {
      if (!this.webViewImpl.guestInstanceId) {
        return;
      }
      return guestViewInternal.setAutoSize(this.webViewImpl.guestInstanceId, {
        enableAutoSize: this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_AUTOSIZE].getValue(),
        min: {
          width: parseInt(this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_MINWIDTH].getValue() || 0),
          height: parseInt(this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_MINHEIGHT].getValue() || 0)
        },
        max: {
          width: parseInt(this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_MAXWIDTH].getValue() || 0),
          height: parseInt(this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_MAXHEIGHT].getValue() || 0)
        }
      });
    };

    return AutosizeDimensionAttribute;

  })(WebViewAttribute);

  AutosizeAttribute = (function(_super) {
    __extends(AutosizeAttribute, _super);

    function AutosizeAttribute(webViewImpl) {
      AutosizeAttribute.__super__.constructor.call(this, webViewConstants.ATTRIBUTE_AUTOSIZE, webViewImpl);
    }

    AutosizeAttribute.prototype.handleMutation = AutosizeDimensionAttribute.prototype.handleMutation;

    return AutosizeAttribute;

  })(BooleanAttribute);

  PartitionAttribute = (function(_super) {
    __extends(PartitionAttribute, _super);

    function PartitionAttribute(webViewImpl) {
      PartitionAttribute.__super__.constructor.call(this, webViewConstants.ATTRIBUTE_PARTITION, webViewImpl);
      this.validPartitionId = true;
    }

    PartitionAttribute.prototype.handleMutation = function(oldValue, newValue) {
      newValue = newValue || '';
      if (!this.webViewImpl.beforeFirstNavigation) {
        window.console.error(webViewConstants.ERROR_MSG_ALREADY_NAVIGATED);
        this.setValueIgnoreMutation(oldValue);
        return;
      }
      if (newValue === 'persist:') {
        this.validPartitionId = false;
        return window.console.error(webViewConstants.ERROR_MSG_INVALID_PARTITION_ATTRIBUTE);
      }
    };

    return PartitionAttribute;

  })(WebViewAttribute);

  SrcAttribute = (function(_super) {
    __extends(SrcAttribute, _super);

    function SrcAttribute(webViewImpl) {
      SrcAttribute.__super__.constructor.call(this, webViewConstants.ATTRIBUTE_SRC, webViewImpl);
      this.setupMutationObserver();
    }

    SrcAttribute.prototype.getValue = function() {
      if (this.webViewImpl.webviewNode.hasAttribute(this.name)) {
        return resolveUrl(this.webViewImpl.webviewNode.getAttribute(this.name));
      } else {
        return '';
      }
    };

    SrcAttribute.prototype.handleMutation = function(oldValue, newValue) {
      if (!newValue && oldValue) {
        this.setValueIgnoreMutation(oldValue);
        return;
      }
      return this.parse();
    };

    SrcAttribute.prototype.setupMutationObserver = function() {
      var params;
      this.observer = new MutationObserver((function(_this) {
        return function(mutations) {
          var mutation, newValue, oldValue, _i, _len;
          for (_i = 0, _len = mutations.length; _i < _len; _i++) {
            mutation = mutations[_i];
            oldValue = mutation.oldValue;
            newValue = _this.getValue();
            if (oldValue !== newValue) {
              return;
            }
            _this.handleMutation(oldValue, newValue);
          }
        };
      })(this));
      params = {
        attributes: true,
        attributeOldValue: true,
        attributeFilter: [this.name]
      };
      return this.observer.observe(this.webViewImpl.webviewNode, params);
    };

    SrcAttribute.prototype.parse = function() {
      var httpreferrer, urlOptions;
      if (!this.webViewImpl.elementAttached || !this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_PARTITION].validPartitionId || !this.getValue()) {
        return;
      }
      if (this.webViewImpl.guestInstanceId == null) {
        if (this.webViewImpl.beforeFirstNavigation) {
          this.webViewImpl.beforeFirstNavigation = false;
          this.webViewImpl.createGuest();
        }
        return;
      }
      httpreferrer = this.webViewImpl.attributes[webViewConstants.ATTRIBUTE_HTTPREFERRER].getValue();
      urlOptions = httpreferrer ? {
        httpreferrer: httpreferrer
      } : {};
      return remote.getGuestWebContents(this.webViewImpl.guestInstanceId).loadUrl(this.getValue(), urlOptions);
    };

    return SrcAttribute;

  })(WebViewAttribute);

  HttpReferrerAttribute = (function(_super) {
    __extends(HttpReferrerAttribute, _super);

    function HttpReferrerAttribute(webViewImpl) {
      HttpReferrerAttribute.__super__.constructor.call(this, webViewConstants.ATTRIBUTE_HTTPREFERRER, webViewImpl);
    }

    return HttpReferrerAttribute;

  })(WebViewAttribute);

  PreloadAttribute = (function(_super) {
    __extends(PreloadAttribute, _super);

    function PreloadAttribute(webViewImpl) {
      PreloadAttribute.__super__.constructor.call(this, webViewConstants.ATTRIBUTE_PRELOAD, webViewImpl);
    }

    PreloadAttribute.prototype.getValue = function() {
      var preload, protocol;
      if (!this.webViewImpl.webviewNode.hasAttribute(this.name)) {
        return '';
      }
      preload = resolveUrl(this.webViewImpl.webviewNode.getAttribute(this.name));
      protocol = preload.substr(0, 5);
      if (protocol !== 'file:' && protocol !== 'asar:') {
        console.error(webViewConstants.ERROR_MSG_INVALID_PRELOAD_ATTRIBUTE);
        preload = '';
      }
      return preload;
    };

    return PreloadAttribute;

  })(WebViewAttribute);

  WebViewImpl.prototype.setupWebViewAttributes = function() {
    var attribute, autosizeAttributes, _i, _len, _results;
    this.attributes = {};
    this.attributes[webViewConstants.ATTRIBUTE_ALLOWTRANSPARENCY] = new AllowTransparencyAttribute(this);
    this.attributes[webViewConstants.ATTRIBUTE_AUTOSIZE] = new AutosizeAttribute(this);
    this.attributes[webViewConstants.ATTRIBUTE_PARTITION] = new PartitionAttribute(this);
    this.attributes[webViewConstants.ATTRIBUTE_SRC] = new SrcAttribute(this);
    this.attributes[webViewConstants.ATTRIBUTE_HTTPREFERRER] = new HttpReferrerAttribute(this);
    this.attributes[webViewConstants.ATTRIBUTE_NODEINTEGRATION] = new BooleanAttribute(webViewConstants.ATTRIBUTE_NODEINTEGRATION, this);
    this.attributes[webViewConstants.ATTRIBUTE_PLUGINS] = new BooleanAttribute(webViewConstants.ATTRIBUTE_PLUGINS, this);
    this.attributes[webViewConstants.ATTRIBUTE_PRELOAD] = new PreloadAttribute(this);
    autosizeAttributes = [webViewConstants.ATTRIBUTE_MAXHEIGHT, webViewConstants.ATTRIBUTE_MAXWIDTH, webViewConstants.ATTRIBUTE_MINHEIGHT, webViewConstants.ATTRIBUTE_MINWIDTH];
    _results = [];
    for (_i = 0, _len = autosizeAttributes.length; _i < _len; _i++) {
      attribute = autosizeAttributes[_i];
      _results.push(this.attributes[attribute] = new AutosizeDimensionAttribute(attribute, this));
    }
    return _results;
  };

}).call(this);
